/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerCacheManager;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeHandlerCacheManager;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.FurnaceRecipe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lotr.client.gui.LOTRGuiUnsmeltery;
import lotr.common.LOTRMod;
import lotr.common.tileentity.LOTRTileEntityUnsmeltery;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Logger;

@RegisteredHandler
public class UnsmelteryRecipeHandler
extends AbstractRecipeHandler<UnsmelteryRecipe> {
    private final UnsmelteryRecipeHandlerRenderer renderer = new UnsmelteryRecipeHandlerRenderer();
    private final UnsmelteryRecipeHandlerCacheManager cacheManager = new UnsmelteryRecipeHandlerCacheManager(this);
    private final UnsmelteryRecipeHandlerRecipeViewer recipeViewer = new UnsmelteryRecipeHandlerRecipeViewer(this);
    private final LOTRTileEntityUnsmeltery unsmeltery = new LOTRTileEntityUnsmeltery();
    private Method getLargestUnsmeltingResultMethod;
    private boolean wasCacheLoaded = false;
    private boolean areRecipesLoaded = false;
    private boolean wasPlayerLoggedIn = false;
    private final Collection<UnsmelteryRecipe> recipesLoadedOnWorldJoin = new ArrayList<UnsmelteryRecipe>(500);

    public UnsmelteryRecipeHandler() {
        super("lotr.unsmeltery");
    }

    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        super.onPreLoad(config, logger);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            this.getLargestUnsmeltingResultMethod = ((Object)((Object)this.unsmeltery)).getClass().getDeclaredMethod("getLargestUnsmeltingResult", ItemStack.class);
            this.getLargestUnsmeltingResultMethod.setAccessible(true);
        }
        catch (Exception e) {
            logger.error("Couldn't access the LOTR unsmeltery: ", (Throwable)e);
        }
    }

    public String getDisplayName() {
        return LOTRMod.unsmeltery.func_149732_F();
    }

    public int getRecipesPerPage() {
        return 2;
    }

    public Collection<UnsmelteryRecipe> getDynamicUsageRecipes(ItemStack ingredient) {
        ArrayList<UnsmelteryRecipe> usageRecipes = new ArrayList<UnsmelteryRecipe>();
        UnsmelteryRecipe recipe = this.createUnsmelteryRecipe(ingredient);
        if (recipe != null) {
            usageRecipes.add(recipe);
        }
        return usageRecipes;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.wasPlayerLoggedIn = true;
    }

    @SubscribeEvent
    public void onWorldExit(WorldEvent.Unload event) {
        this.unsmeltery.func_145834_a(null);
        this.wasPlayerLoggedIn = false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.wasPlayerLoggedIn && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            this.unsmeltery.func_145834_a((World)Minecraft.func_71410_x().field_71441_e);
            if (!this.areRecipesLoaded && !this.wasCacheLoaded) {
                long start = System.currentTimeMillis();
                int recipeCount = this.staticRecipes.size();
                this.loadUnsmelteryCraftingRecipes();
                this.logger.info("Loaded additional " + (this.staticRecipes.size() - recipeCount) + " static recipes within " + (System.currentTimeMillis() - start) + " ms");
            }
            this.cacheManager.invalidateCache();
            RecipeHandlerUtils.getInstance().forceRecipeCacheRefresh();
            this.wasPlayerLoggedIn = false;
        }
    }

    protected void loadUnsmelteryCraftingRecipes() {
        RecipeHandlerUtils.getInstance().getItemList().forEach(stack -> {
            UnsmelteryRecipe recipe = this.createUnsmelteryRecipe((ItemStack)stack);
            if (recipe != null) {
                this.staticRecipes.add(recipe);
                this.recipesLoadedOnWorldJoin.add(recipe);
            }
        });
        this.areRecipesLoaded = true;
    }

    protected UnsmelteryRecipe createUnsmelteryRecipe(ItemStack ingredient) {
        UnsmelteryRecipe ret = null;
        ItemStack result = this.getLargestUnsmeltingResult(ingredient);
        if (result != null) {
            int maxStackSize = UnsmelteryRecipeHandler.getMaxUnsmeltingResultCount(ingredient, result);
            int minStackSize = UnsmelteryRecipeHandler.getMinUnsmeltingResultCount(ingredient, result);
            result.field_77994_a = 1;
            ret = new UnsmelteryRecipe(ingredient.func_77946_l(), result.func_77946_l(), minStackSize, maxStackSize);
        }
        return ret;
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(UnsmelteryRecipe recipe, EnumRecipeItemRole role) {
        ArrayList<RecipeItemSlot> ret = new ArrayList<RecipeItemSlot>();
        switch (role) {
            case INGREDIENT: {
                ret.add(this.createRecipeItemSlot(51, 6));
                break;
            }
            case OTHER: {
                ret.add(this.createRecipeItemSlot(51, 42));
                break;
            }
            case RESULT: {
                ret.add(this.createRecipeItemSlot(111, 24));
                ret.add(this.createRecipeItemSlot(136, 24));
            }
        }
        return ret;
    }

    public UnsmelteryRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public RecipeHandlerCacheManager<UnsmelteryRecipe> getCacheManager() {
        return this.cacheManager;
    }

    public RecipeHandlerRecipeViewer<UnsmelteryRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public ItemStack getLargestUnsmeltingResult(ItemStack stack) {
        ItemStack ret = null;
        try {
            ret = (ItemStack)this.getLargestUnsmeltingResultMethod.invoke((Object)this.unsmeltery, stack);
        }
        catch (Exception e) {
            this.logger.error("Couldn't get the largest unsmeltery result: ", (Throwable)e);
        }
        return ret;
    }

    public int getDefaultOrder() {
        return 7000;
    }

    public static int getMinUnsmeltingResultCount(ItemStack ingredient, ItemStack largestPossibleResult) {
        return UnsmelteryRecipeHandler.getUnsmeltingResultCount(ingredient, largestPossibleResult, 0.7f);
    }

    public static int getMaxUnsmeltingResultCount(ItemStack ingredient, ItemStack largestPossibleResult) {
        return UnsmelteryRecipeHandler.getUnsmeltingResultCount(ingredient, largestPossibleResult, 1.0f);
    }

    public static int getUnsmeltingResultCount(ItemStack ingredient, ItemStack largestPossibleResult, float minReduction) {
        float size = (float)largestPossibleResult.field_77994_a * 0.8f;
        if (ingredient.func_77984_f()) {
            size *= (float)(ingredient.func_77958_k() - ingredient.func_77960_j()) / (float)ingredient.func_77958_k();
        }
        return Math.max(0, Math.round(size *= minReduction));
    }

    public class UnsmelteryRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<UnsmelteryRecipe, UnsmelteryRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public UnsmelteryRecipeHandlerRecipeViewer(UnsmelteryRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(LOTRGuiUnsmeltery.class);
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public Collection<UnsmelteryRecipe> getAllRecipes() {
            return ((UnsmelteryRecipeHandler)this.handler).getStaticRecipes();
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiUnsmeltery.class ? 18 : 8;
        }
    }

    public class UnsmelteryRecipeHandlerRenderer
    implements RecipeHandlerRenderer<UnsmelteryRecipeHandler, UnsmelteryRecipe> {
        public void renderBackground(UnsmelteryRecipeHandler handler, UnsmelteryRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("lotr:gui/unsmelter.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(0, 0, 5, 11, 166, 65);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(106, 19, 26, 26, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(106, 13, 51, 6, 22, 28);
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(131, 13, 51, 6, 22, 28);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(74, 23, 176, 14, 24, 16, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.INCREASE_RIGHT);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(51, 25, 176, 0, 14, 14, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.DECREASE_DOWN);
        }

        public void renderForeground(UnsmelteryRecipeHandler handler, UnsmelteryRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().drawText(StatCollector.func_74838_a((String)"neiLotr.handler.unsmeltery.minLabel"), 111, 14, 0x404040, false);
            RecipeHandlerRendererUtils.getInstance().drawText(StatCollector.func_74838_a((String)"neiLotr.handler.unsmeltery.maxLabel"), 135, 14, 0x404040, false);
            RecipeHandlerRendererUtils.getInstance().drawText(Integer.toString(recipe.getMinCount()), 122, 33, -1, true);
            RecipeHandlerRendererUtils.getInstance().drawText(Integer.toString(recipe.getMaxCount()), 147, 33, -1, true);
        }
    }

    public static class UnsmelteryRecipe
    extends FurnaceRecipe {
        private final ItemStack ingredientItem;
        private final ItemStack resultItem;
        private final int minCount;
        private final int maxCount;
        public static final String INGREDIENT_ITEM_KEY = "ingredientItem";
        public static final String RESULT_ITEM_KEY = "resultItem";
        public static final String MIN_COUNT_KEY = "minCount";
        public static final String MAX_COUNT_KEY = "maxCount";

        public UnsmelteryRecipe(ItemStack ingredient, ItemStack result, int minCount, int maxCount) {
            super(ingredient, result);
            this.ingredientItem = ingredient.func_77946_l();
            this.resultItem = result.func_77946_l();
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.add(result, this.results);
        }

        public boolean consumes(ItemStack ingredient) {
            return false;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public static UnsmelteryRecipe readRecipeFromNBT(NBTTagCompound parent) {
            UnsmelteryRecipe ret = null;
            if (parent.func_74764_b(INGREDIENT_ITEM_KEY) && parent.func_74764_b(RESULT_ITEM_KEY) && parent.func_74764_b(MIN_COUNT_KEY) && parent.func_74764_b(MAX_COUNT_KEY)) {
                ret = new UnsmelteryRecipe(RecipeHandlerUtils.getInstance().readItemStackFromNBT(parent.func_74775_l(INGREDIENT_ITEM_KEY)), RecipeHandlerUtils.getInstance().readItemStackFromNBT(parent.func_74775_l(RESULT_ITEM_KEY)), parent.func_74762_e(MIN_COUNT_KEY), parent.func_74762_e(MAX_COUNT_KEY));
            }
            return ret;
        }

        public void writeRecipeToNBT(NBTTagCompound parent) {
            NBTTagCompound ingredientItem = new NBTTagCompound();
            NBTTagCompound resultItem = new NBTTagCompound();
            RecipeHandlerUtils.getInstance().writeItemStackToNBT(this.ingredientItem, ingredientItem);
            RecipeHandlerUtils.getInstance().writeItemStackToNBT(this.resultItem, resultItem);
            parent.func_74782_a(INGREDIENT_ITEM_KEY, (NBTBase)ingredientItem);
            parent.func_74782_a(RESULT_ITEM_KEY, (NBTBase)resultItem);
            parent.func_74768_a(MIN_COUNT_KEY, this.minCount);
            parent.func_74768_a(MAX_COUNT_KEY, this.maxCount);
        }
    }

    public class UnsmelteryRecipeHandlerCacheManager
    extends AbstractRecipeHandlerCacheManager<UnsmelteryRecipe> {
        public UnsmelteryRecipeHandlerCacheManager(UnsmelteryRecipeHandler handler) {
            super((RecipeHandler)handler);
        }

        public Collection<UnsmelteryRecipe> readRecipesFromCache(NBTTagCompound cacheHeaderTag, NBTTagCompound cacheContentTag) {
            ArrayList<UnsmelteryRecipe> ret = new ArrayList<UnsmelteryRecipe>(150);
            for (String key : cacheContentTag.func_150296_c()) {
                NBTTagCompound recipeTag = cacheContentTag.func_74775_l(key);
                UnsmelteryRecipe recipe = UnsmelteryRecipe.readRecipeFromNBT(recipeTag);
                if (recipe == null) continue;
                ret.add(recipe);
            }
            UnsmelteryRecipeHandler.this.wasCacheLoaded = ret.size() > 0;
            UnsmelteryRecipeHandler.this.recipesLoadedOnWorldJoin.addAll(ret);
            return ret;
        }

        public void writeRecipesToCache(NBTTagCompound cacheHeaderTag, NBTTagCompound cacheContentTag) {
            super.writeRecipesToCache(cacheHeaderTag, cacheContentTag);
            int recipeIndex = 0;
            for (UnsmelteryRecipe recipe : UnsmelteryRecipeHandler.this.recipesLoadedOnWorldJoin) {
                NBTTagCompound recipeTag = new NBTTagCompound();
                recipe.writeRecipeToNBT(recipeTag);
                cacheContentTag.func_74782_a(Integer.toString(recipeIndex++), (NBTBase)recipeTag);
            }
        }
    }
}

